<?php
/**
 * Change Class
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

function saveChanges() {
    global $_POST;
	
    $cfgFile = __PATH_CHANGECLASS_ROOT__.'config.json';
	if(!is_writable($cfgFile)) throw new Exception('The configuration file is not writable.');
	$pluginConfig = file_get_contents($cfgFile);
	if(!$pluginConfig) throw new Exception('Error loading config file.');
	$pluginConfig = json_decode($pluginConfig, true);
	if(!is_array($pluginConfig)) throw new Exception('Error loading config file.');
	
	if(!Validator::UnsignedNumber($_POST['setting_1'])) throw new Exception('Submitted setting is not valid (active)');
	if(!in_array($_POST['setting_1'], array(1, 0))) throw new Exception('Submitted setting is not valid (active)');
	$pluginConfig['active'] = $_POST['setting_1'];
	
	if(!Validator::UnsignedNumber($_POST['setting_2'])) throw new Exception('Submitted setting is not valid (credit_config)');
	$pluginConfig['credit_config'] = $_POST['setting_2'];
	
	if(!Validator::UnsignedNumber($_POST['setting_3'])) throw new Exception('Submitted setting is not valid (credit_cost)');
	$pluginConfig['credit_cost'] = $_POST['setting_3'];
	
	if(!Validator::UnsignedNumber($_POST['setting_12'])) throw new Exception('Submitted setting is not valid (required_zen)');
	$pluginConfig['required_zen'] = $_POST['setting_12'];
	
	if(!Validator::UnsignedNumber($_POST['setting_4'])) throw new Exception('Submitted setting is not valid (minimum_level)');
	$pluginConfig['minimum_level'] = $_POST['setting_4'];
	
	if(!Validator::UnsignedNumber($_POST['setting_5'])) throw new Exception('Submitted setting is not valid (minimum_master)');
	$pluginConfig['minimum_master'] = $_POST['setting_5'];
	
	if(!Validator::UnsignedNumber($_POST['setting_6'])) throw new Exception('Submitted setting is not valid (minimum_resets)');
	$pluginConfig['minimum_resets'] = $_POST['setting_6'];
	
	if(!Validator::UnsignedNumber($_POST['setting_7'])) throw new Exception('Submitted setting is not valid (wipe_inventory)');
	if(!in_array($_POST['setting_7'], array(1, 0))) throw new Exception('Submitted setting is not valid (wipe_inventory)');
	$pluginConfig['wipe_inventory'] = $_POST['setting_7'];
	
	if(!Validator::UnsignedNumber($_POST['setting_8'])) throw new Exception('Submitted setting is not valid (wipe_skills)');
	if(!in_array($_POST['setting_8'], array(1, 0))) throw new Exception('Submitted setting is not valid (wipe_skills)');
	$pluginConfig['wipe_skills'] = $_POST['setting_8'];
	
	if(!Validator::UnsignedNumber($_POST['setting_9'])) throw new Exception('Submitted setting is not valid (wipe_quests)');
	if(!in_array($_POST['setting_9'], array(1, 0))) throw new Exception('Submitted setting is not valid (wipe_quests)');
	$pluginConfig['wipe_quests'] = $_POST['setting_9'];
	
	if(!Validator::UnsignedNumber($_POST['setting_10'])) throw new Exception('Submitted setting is not valid (give_back_points)');
	if(!in_array($_POST['setting_10'], array(1, 0))) throw new Exception('Submitted setting is not valid (give_back_points)');
	$pluginConfig['give_back_points'] = $_POST['setting_10'];
	
	if(!is_array($_POST['setting_11'])) throw new Exception('Submitted setting is not valid (class_points)');
	$pluginConfig['class_points'] = $_POST['setting_11'];
	
	$fp = fopen($cfgFile, 'w');
	if(!fwrite($fp, json_encode($pluginConfig, JSON_PRETTY_PRINT))) throw new Exception('There has been an error while saving changes.');
	fclose($fp);
}

if(check_value($_POST['submit_changes'])) {
	try {
		saveChanges();
		message('success', 'Settings successfully saved.');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

if(check_value($_GET['checkusercplinks'])) {
	try {
		$ChangeClass = new \Plugin\ChangeClass\ChangeClass();
		$ChangeClass->checkPluginUsercpLinks();
		message('success', 'UserCP Links Successfully Added!');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

// load configs
$pluginConfig = file_get_contents(__PATH_CHANGECLASS_ROOT__.'config.json');
if(!$pluginConfig) throw new Exception('Error loading config file.');
$pluginConfig = json_decode($pluginConfig, true);
if(!is_array($pluginConfig)) throw new Exception('Error loading config file.');

// credit system
$creditSystem = new CreditSystem();

// Unitpay
$ChangeClass = new \Plugin\ChangeClass\ChangeClass();
$characterClasses = $ChangeClass->getCharacterClasses();

/*
foreach($characterClasses as $key => $row) {
	$base = $row['base_stats']['str']+$row['base_stats']['agi']+$row['base_stats']['vit']+$row['base_stats']['ene']+$row['base_stats']['cmd'];
	$sevenPoints = array(48,64,96,112);
	
	$p1 = 5;
	$p2 = 6;
	
	if(in_array($key, $sevenPoints)) {
		$p1 = 7;
		$p2 = 7;
	}
	
	$result = $base + (219*$p1) + (180*$p2) + 20 + 20 + 50;
}
*/

?>
<h2>Change Class Settings</h2>
<form action="" method="post">
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
            <th>Status<br /><span>Enables or disables the change class feature.</span></th>
            <td>
                <?php enabledisableCheckboxes('setting_1', $pluginConfig['active'], 'Enabled', 'Disabled'); ?>
            </td>
        </tr>
		<tr>
			<th>Credit Configuration<br /><span>Select the type of credits you would like to charge the player to use this feature.</span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_2", $pluginConfig['credit_config'], "form-control"); ?>
			</td>
		</tr>
		<tr>
            <th>Credit Cost<br /><span>Amount of credits the player will pay to change their character class. Set to 0 to disable.</span></th>
            <td>
                <input class="form-control" type="text" name="setting_3" value="<?php echo $pluginConfig['credit_cost']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Zen Cost<br /><span>Amount of zen the player will pay to change their character class. Set to 0 to disable.</span></th>
            <td>
                <input class="form-control" type="text" name="setting_12" value="<?php echo $pluginConfig['required_zen']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Minimum Required Level<br /><span>Minimum level required to change class. Set to 0 to disable.</span></th>
            <td>
                <input class="form-control" type="text" name="setting_4" value="<?php echo $pluginConfig['minimum_level']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Minimim Required Master Level<br /><span>Minimum master level required to change class. Set to 0 to disable.</span></th>
            <td>
                <input class="form-control" type="text" name="setting_5" value="<?php echo $pluginConfig['minimum_master']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Minimum Required Resets<br /><span>Minimum amount of resets required to change class. Set to 0 to disable.</span></th>
            <td>
                <input class="form-control" type="text" name="setting_6" value="<?php echo $pluginConfig['minimum_resets']; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Wipe Inventory<br /><span>Wipes the player's inventory and equipment.</span></th>
            <td>
                <?php enabledisableCheckboxes('setting_7', $pluginConfig['wipe_inventory'], 'Enabled', 'Disabled'); ?>
            </td>
        </tr>
		<tr>
            <th>Wipe Skills<br /><span>Wipes the player's skills (this also wipes the skill tree).</span></th>
            <td>
                <?php enabledisableCheckboxes('setting_8', $pluginConfig['wipe_skills'], 'Enabled', 'Disabled'); ?>
            </td>
        </tr>
		<tr>
            <th>Wipe Quests<br /><span>Wipes the player's quests.</span></th>
            <td>
                <?php enabledisableCheckboxes('setting_9', $pluginConfig['wipe_quests'], 'Enabled', 'Disabled'); ?>
            </td>
        </tr>
		<tr>
            <th>Give Back Level-Up-Points<br /><span>If enabled, the player will be given back its added level-up-points and any points not spent yet. If disabled, the player will be given the set amount of points defined in the table below.</span></th>
            <td>
                <?php enabledisableCheckboxes('setting_10', $pluginConfig['give_back_points'], 'Enabled', 'Disabled'); ?>
            </td>
        </tr>
    </table>
	
	<h3>Level up Points per Class</h3>
	<p>Set the amount of level up points that are going to be given to the character after they perform the class change.</p>
	<table class="table table-striped table-bordered table-hover module_config_tables">
	<?php foreach($characterClasses as $classId => $classInfo) { ?>
		<tr>
            <th><?php echo $classInfo[0]; ?><br /><span></span></th>
            <td>
                <input class="form-control" type="text" name="setting_11[<?php echo $classId; ?>]" value="<?php echo array_key_exists($classId, $pluginConfig['class_points']) ? $pluginConfig['class_points'][$classId] : 0; ?>"/>
            </td>
        </tr>
	<?php } ?>
    </table>
	
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
            <td colspan="2"><input type="submit" name="submit_changes" value="Save Changes" class="btn btn-success"/></td>
        </tr>
    </table>
</form>

<h2>UserCP Links</h2>
<p>Click the button below to automatically add the plugin's links to the user control panel menu.</p>
<a href="<?php echo admincp_base('changeclass&page=settings&checkusercplinks=1'); ?>" class="btn btn-primary">Add UserCP Links</a>